<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include 'includes/db.php';

$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!isset($_POST["email"]) || !isset($_POST["password"])) {
        $error_message = "Missing email or password.";
    } else {
        $email = $conn->real_escape_string($_POST["email"]);
        $password = $_POST["password"];

        $sql = "SELECT * FROM users WHERE email='$email'";
        $result = $conn->query($sql);

        if (!$result) {
            $error_message = "Query failed: " . $conn->error;
        } elseif ($result->num_rows == 1) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password_hash'])) {
                $_SESSION["user_id"] = $user["id"];
                $_SESSION["role"] = $user["role"];
                $_SESSION["name"] = $user["name"];
                header("Location: dashboard.php");
                exit;
            } else {
                $error_message = "Invalid password.";
            }
        } else {
            $error_message = "User not found.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="flex justify-center items-center min-h-screen bg-gray-100">
    <div class="bg-white p-8 rounded-lg shadow-md w-96">
        <h2 class="text-2xl font-bold mb-4 text-center">Login</h2>

        <!-- Error Message -->
        <?php if ($error_message): ?>
            <p class="text-red-600 text-sm mb-4"><?= $error_message ?></p>
        <?php endif; ?>

        <form method="POST">
            <label class="block font-medium">Email:</label>
            <input type="email" name="email" class="w-full p-2 border rounded mb-3" required>

            <label class="block font-medium">Password:</label>
            <input type="password" name="password" class="w-full p-2 border rounded mb-3" required>

            <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">
                Login
            </button>
        </form>

        <p class="text-sm mt-3 text-center">
            Don't have an account? <a href="register.php" class="text-blue-600">Sign Up</a>
        </p>
    </div>
</body>
</html>
