<?php
include 'includes/db.php';

header("Content-Type: application/json"); // Set response type to JSON

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!isset($_POST['room_id'], $_POST['check_in'], $_POST['check_out'])) {
        echo json_encode(["error" => "Missing required parameters."]);
        exit();
    }

    $room_id = $_POST['room_id'];
    $check_in = $_POST['check_in'];
    $check_out = $_POST['check_out'];

    // Check if the room exists in the database
    $room_stmt = $conn->prepare("SELECT id FROM rooms WHERE id = ?");
    $room_stmt->bind_param("i", $room_id);
    $room_stmt->execute();
    $room_result = $room_stmt->get_result();

    if ($room_result->num_rows == 0) {
        echo json_encode(["error" => "Room not found."]);
        exit();
    }

    // Check if the room is already booked for the selected dates
    $stmt = $conn->prepare("
        SELECT COUNT(*) AS booked_count FROM booking 
        WHERE room_id = ? AND status IN ('pending', 'confirmed') 
        AND ((check_in <= ? AND check_out > ?) OR (check_in < ? AND check_out >= ?))
    ");
    $stmt->bind_param("issss", $room_id, $check_out, $check_in, $check_in, $check_out);
    
    if (!$stmt->execute()) {
        echo json_encode(["error" => "Database query failed: " . $conn->error]);
        exit();
    }

    $result = $stmt->get_result()->fetch_assoc();
    $is_available = ($result['booked_count'] == 0); // If no overlapping bookings, room is available

    echo json_encode([
        "available" => $is_available
    ]);
}
?>
