<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../includes/db.php';

// Handle user creation
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["create_user"])) {
    $name = $conn->real_escape_string($_POST["name"]);
    $email = $conn->real_escape_string($_POST["email"]);
    $phone = $conn->real_escape_string($_POST["phone"]);
    $password = password_hash($_POST["password"], PASSWORD_BCRYPT);
    $role = "guest"; // Default role for new users

    $sql_insert = "INSERT INTO users (name, email, phone, password_hash, role) VALUES ('$name', '$email', '$phone', '$password', '$role')";
    if ($conn->query($sql_insert)) {
        echo "<script>alert('User added successfully!'); window.location='manage_users.php';</script>";
    } else {
        echo "<script>alert('Error adding user: " . $conn->error . "');</script>";
    }
}

// Handle user deletion
if (isset($_GET["delete"])) {
    $id = (int) $_GET["delete"];
    $conn->query("DELETE FROM users WHERE id = $id");
    echo "<script>alert('User deleted successfully!'); window.location='manage_users.php';</script>";
}

// Fetch all users
$sql_users = "SELECT * FROM users ORDER BY id DESC";
$result_users = $conn->query($sql_users);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Manage Users</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2">
                <a href="admin_dashboard.php" class="flex items-center py-2 px-3 bg-gray-700 rounded">
                    <i class="fas fa-chart-line mr-2"></i> Dashboard
                </a>
            </li>
            <li class="mb-2">
                <a href="admin.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-calendar-check mr-2"></i> Bookings
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_rooms.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-bed mr-2"></i> Rooms
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_users.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-users mr-2"></i> Users
                </a>
            </li>
            <li class="mb-2">
                <a href="add_accommodation.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-plus-circle mr-2"></i> Add Accommodation
                </a>
            </li>
            <li class="mb-2">
                <a href="../index.html" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-globe mr-2"></i> View Website
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="w-3/4 p-10">
        <h1 class="text-3xl font-bold mb-5">Manage Users</h1>

        <!-- Add User Form -->
        <div class="bg-white p-5 rounded-lg shadow mb-5">
            <h2 class="text-xl font-semibold mb-3">Create New User</h2>
            <form method="POST">
                <div class="grid grid-cols-2 gap-4">
                    <input type="text" name="name" placeholder="Full Name" required class="border p-2 rounded w-full">
                    <input type="email" name="email" placeholder="Email" required class="border p-2 rounded w-full">
                    <input type="text" name="phone" placeholder="Phone" required class="border p-2 rounded w-full">
                    <input type="password" name="password" placeholder="Password" required class="border p-2 rounded w-full">
                </div>
                <button type="submit" name="create_user" class="mt-3 bg-blue-500 text-white px-4 py-2 rounded">Add User</button>
            </form>
        </div>

        <!-- Users Table -->
        <table class="w-full border mt-5">
            <tr class="bg-gray-300">
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Role</th>
                <th>Action</th>
            </tr>
            <?php while ($row = $result_users->fetch_assoc()): ?>
            <tr class="border">
                <td><?= $row['id'] ?></td>
                <td><?= $row['name'] ?></td>
                <td><?= $row['email'] ?></td>
                <td><?= $row['phone'] ?></td>
                <td class="font-bold <?= $row['role'] == 'admin' ? 'text-red-600' : 'text-green-600' ?>">
                    <?= ucfirst($row['role']) ?>
                </td>
                <td>
                    <?php if ($row['role'] != 'admin'): ?>
                        <a href="manage_users.php?delete=<?= $row['id'] ?>" class="text-red-600">Delete</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endwhile; ?>
        </table>
    </div>
</body>
</html>
