<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../includes/db.php';

// Handle form submission to add new room
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['add_room'])) {
    $name = $conn->real_escape_string($_POST['name']);
    $price = $conn->real_escape_string($_POST['price']);
    $status = $conn->real_escape_string($_POST['status']);

    $stmt = $conn->prepare("INSERT INTO rooms (name, price, status) VALUES (?, ?, ?)");
    $stmt->bind_param("sds", $name, $price, $status);

    if ($stmt->execute()) {
        $message = "<p class='text-green-600'>Room added successfully!</p>";
    } else {
        $message = "<p class='text-red-600'>Error: " . $conn->error . "</p>";
    }
}

// Fetch all rooms
$rooms = $conn->query("SELECT * FROM rooms");

// Handle delete room
if (isset($_GET['delete'])) {
    $room_id = $_GET['delete'];
    $conn->query("DELETE FROM rooms WHERE id = $room_id");
    header("Location: manage_rooms.php");
    exit();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Admin - Manage Rooms</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2">
                <a href="admin_dashboard.php" class="flex items-center py-2 px-3 bg-gray-700 rounded">
                    <i class="fas fa-chart-line mr-2"></i> Dashboard
                </a>
            </li>
            <li class="mb-2">
                <a href="admin.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-calendar-check mr-2"></i> Bookings
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_rooms.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-bed mr-2"></i> Rooms
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_users.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-users mr-2"></i> Users
                </a>
            </li>
            <li class="mb-2">
                <a href="add_accommodation.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-plus-circle mr-2"></i> Add Accommodation
                </a>
            </li>
            <li class="mb-2">
                <a href="../index.html" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-globe mr-2"></i> View Website
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="w-3/4 p-10">
        <h1 class="text-3xl font-bold">Manage Rooms</h1>

        <!-- Success/Error Message -->
        <?= isset($message) ? $message : '' ?>

        <!-- Add Room Form -->
        <div class="bg-white p-5 rounded-lg shadow-md mt-5 w-1/2">
            <h2 class="text-xl font-bold mb-3">Add New Room</h2>
            <form method="POST">
                <label class="block font-medium">Room Name:</label>
                <input type="text" name="name" class="w-full p-2 border rounded mb-3" required>

                <label class="block font-medium">Price (Ksh):</label>
                <input type="number" name="price" class="w-full p-2 border rounded mb-3" required>

                <label class="block font-medium">Status:</label>
                <select name="status" class="w-full p-2 border rounded mb-3" required>
                    <option value="available">Available</option>
                    <option value="unavailable">Unavailable</option>
                </select>

                <button type="submit" name="add_room" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">Add Room</button>
            </form>
        </div>

        <!-- Room List Table -->
        <table class="mt-8 w-full border">
            <tr class="bg-gray-300">
                <th>ID</th>
                <th>Room Name</th>
                <th>Price</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
            <?php while ($row = $rooms->fetch_assoc()): ?>
            <tr class="border">
                <td><?= $row['id'] ?></td>
                <td><?= $row['name'] ?></td>
                <td>Ksh <?= number_format($row['price']) ?></td>
                <td class="font-bold <?= $row['status'] == 'available' ? 'text-green-600' : 'text-red-600' ?>">
                    <?= ucfirst($row['status']) ?>
                </td>
                <td>
                    <a href="edit_room.php?id=<?= $row['id'] ?>" class="text-blue-600">Edit</a> |
                    <a href="manage_rooms.php?delete=<?= $row['id'] ?>" class="text-red-600" onclick="return confirm('Are you sure?')">Delete</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </table>
    </div>
</body>
</html>
