<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../includes/db.php';

// Check if room ID is provided
if (!isset($_GET['id'])) {
    header("Location: manage_rooms.php");
    exit();
}

$room_id = $_GET['id'];
$message = "";

// Fetch room details
$stmt = $conn->prepare("SELECT * FROM rooms WHERE id = ?");
$stmt->bind_param("i", $room_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    header("Location: manage_rooms.php");
    exit();
}

$room = $result->fetch_assoc();

// Handle form submission to update room
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_room'])) {
    $name = $conn->real_escape_string($_POST['name']);
    $price = $conn->real_escape_string($_POST['price']);
    $status = $conn->real_escape_string($_POST['status']);

    $update_stmt = $conn->prepare("UPDATE rooms SET name = ?, price = ?, status = ? WHERE id = ?");
    $update_stmt->bind_param("sdsi", $name, $price, $status, $room_id);

    if ($update_stmt->execute()) {
        $message = "<p class='text-green-600'>Room updated successfully!</p>";
        // Refresh room details after update
        $stmt->execute();
        $room = $stmt->get_result()->fetch_assoc();
    } else {
        $message = "<p class='text-red-600'>Error updating room: " . $conn->error . "</p>";
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Edit Room</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2">
                <a href="admin_dashboard.php" class="flex items-center py-2 px-3 bg-gray-700 rounded">
                    <i class="fas fa-chart-line mr-2"></i> Dashboard
                </a>
            </li>
            <li class="mb-2">
                <a href="admin.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-calendar-check mr-2"></i> Bookings
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_rooms.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-bed mr-2"></i> Rooms
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_users.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-users mr-2"></i> Users
                </a>
            </li>
            <li class="mb-2">
                <a href="add_accommodation.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-plus-circle mr-2"></i> Add Accommodation
                </a>
            </li>
            <li class="mb-2">
                <a href="../index.html" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-globe mr-2"></i> View Website
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="w-3/4 p-10">
        <h1 class="text-3xl font-bold">Edit Room</h1>

        <!-- Success/Error Message -->
        <?= $message ?>

        <!-- Edit Room Form -->
        <div class="bg-white p-5 rounded-lg shadow-md mt-5 w-1/2">
            <h2 class="text-xl font-bold mb-3">Update Room Details</h2>
            <form method="POST">
                <label class="block font-medium">Room Name:</label>
                <input type="text" name="name" value="<?= htmlspecialchars($room['name']) ?>" class="w-full p-2 border rounded mb-3" required>

                <label class="block font-medium">Price (Ksh):</label>
                <input type="number" name="price" value="<?= htmlspecialchars($room['price']) ?>" class="w-full p-2 border rounded mb-3" required>

                <label class="block font-medium">Status:</label>
                <select name="status" class="w-full p-2 border rounded mb-3" required>
                    <option value="available" <?= $room['status'] == 'available' ? 'selected' : '' ?>>Available</option>
                    <option value="unavailable" <?= $room['status'] == 'unavailable' ? 'selected' : '' ?>>Unavailable</option>
                </select>

                <button type="submit" name="update_room" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">Update Room</button>
            </form>
        </div>
    </div>
</body>
</html>
