<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../includes/db.php';

// Fetch all payments
$sql_payments = "SELECT p.id, u.name AS user_name, a.name AS room_name, p.payment_method, p.amount, p.payment_status, p.transaction_id, p.created_at 
                FROM payments p
                JOIN users u ON p.user_id = u.id
                JOIN accommodations a ON p.room_id = a.id
                ORDER BY p.created_at DESC";

$result_payments = $conn->query($sql_payments);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Payments | Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.tailwindcss.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.tailwindcss.min.css">
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2">
                <a href="admin_dashboard.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-chart-line mr-2"></i> Dashboard
                </a>
            </li>
            <li class="mb-2">
                <a href="admin.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-calendar-check mr-2"></i> Bookings
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_rooms.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-bed mr-2"></i> Rooms
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_users.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-users mr-2"></i> Users
                </a>
            </li>
            <li class="mb-2">
                <a href="admin_payments.php" class="flex items-center py-2 px-3 bg-gray-700 rounded">
                    <i class="fas fa-money-check-alt mr-2"></i> Payments
                </a>
            </li>
            <li class="mb-2">
                <a href="../index.html" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-globe mr-2"></i> View Website
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="w-3/4 p-10">
        <h1 class="text-3xl font-bold mb-5"> View Receipts</h1>

        <!-- Payments Table -->
        <div class="bg-white p-6 rounded-lg shadow">
            <h2 class="text-xl font-semibold mb-4">All Receipts</h2>

            <table id="paymentsTable" class="w-full table-auto border-collapse">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="px-4 py-2">User</th>
                        <th class="px-4 py-2">Room</th>
                        <th class="px-4 py-2">Method</th>
                        <th class="px-4 py-2">Amount (Ksh)</th>
                        <th class="px-4 py-2">Status</th>
                        <th class="px-4 py-2">Transaction ID</th>
                        <th class="px-4 py-2">Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result_payments->fetch_assoc()): ?>
                        <tr class="border-t">
                            <td class="px-4 py-2"><?= htmlspecialchars($row['user_name']) ?></td>
                            <td class="px-4 py-2"><?= htmlspecialchars($row['room_name']) ?></td>
                            <td class="px-4 py-2"><?= htmlspecialchars($row['payment_method']) ?></td>
                            <td class="px-4 py-2"><?= number_format($row['amount']) ?></td>
                            <td class="px-4 py-2">
                                <span class="px-3 py-1 rounded-full text-white <?= $row['payment_status'] === 'Completed' ? 'bg-green-500' : 'bg-red-500' ?>">
                                    <?= htmlspecialchars($row['payment_status']) ?>
                                </span>
                            </td>
                            <td class="px-4 py-2"><?= htmlspecialchars($row['transaction_id']) ?></td>
                            <td class="px-4 py-2"><?= date('d M Y, H:i', strtotime($row['created_at'])) ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function () {
            $('#paymentsTable').DataTable({
                "order": [[6, "desc"]], // Sort by Date
                "pageLength": 10,
                "responsive": true
            });
        });
    </script>
</body>
</html>
