<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../includes/db.php';

// Total Sales from confirmed bookings
$sql_sales = "SELECT SUM(total_price) AS total_sales FROM booking WHERE status = 'confirmed'";
$result_sales = $conn->query($sql_sales);
$total_sales = $result_sales->fetch_assoc()['total_sales'] ?? 0;

// Total Visitors (unique users)
$sql_visitors = "SELECT COUNT(DISTINCT user_id) AS total_visitors FROM booking";
$result_visitors = $conn->query($sql_visitors);
$total_visitors = $result_visitors->fetch_assoc()['total_visitors'] ?? 0;

// Popular Room Types (Join accommodations table)
$sql_rooms = "SELECT a.name AS room_type, COUNT(b.id) AS count 
              FROM booking b
              JOIN accommodations a ON b.room_id = a.id 
              GROUP BY a.name
              ORDER BY count DESC";
$result_rooms = $conn->query($sql_rooms);
$room_types = [];
while ($row = $result_rooms->fetch_assoc()) {
    $room_types[$row['room_type']] = $row['count'];
}

// Bookings per Month
$sql_bookings_month = "SELECT DATE_FORMAT(check_in, '%Y-%m') AS month, COUNT(*) AS count FROM booking GROUP BY month ORDER BY month";
$result_bookings_month = $conn->query($sql_bookings_month);
$bookings_per_month = [];
while ($row = $result_bookings_month->fetch_assoc()) {
    $bookings_per_month[$row['month']] = $row['count'];
}

// Bookings per Day
$sql_bookings_day = "SELECT DATE(check_in) AS day, COUNT(*) AS count FROM booking GROUP BY day ORDER BY day";
$result_bookings_day = $conn->query($sql_bookings_day);
$bookings_per_day = [];
while ($row = $result_bookings_day->fetch_assoc()) {
    $bookings_per_day[$row['day']] = $row['count'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Admin Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2">
                <a href="admin_dashboard.php" class="flex items-center py-2 px-3 bg-gray-700 rounded">
                    <i class="fas fa-chart-line mr-2"></i> Dashboard
                </a>
            </li>
            <li class="mb-2">
                <a href="admin.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-calendar-check mr-2"></i> Bookings
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_rooms.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-bed mr-2"></i> Rooms
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_users.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-users mr-2"></i> Users
                </a>
            </li>
            <li class="mb-2">
                <a href="add_accommodation.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-plus-circle mr-2"></i> Add Accommodation
                </a>
            </li>
            <li class="mb-2">
                <a href="admin_payments.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                     <i class="fas fa-money-check-alt mr-2"></i> Payments
                </a>
            </li>

            <li class="mb-2">
                <a href="../index.html" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-globe mr-2"></i> View Website
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="w-3/4 p-10">
        <h1 class="text-3xl font-bold mb-5">Admin Dashboard</h1>

        <!-- Stats -->
        <div class="grid grid-cols-2 gap-6">
            <div class="bg-green-500 text-white p-5 rounded-lg shadow">
                <h2 class="text-lg font-semibold">Total Sales</h2>
                <p class="text-2xl font-bold">Ksh <?= number_format($total_sales) ?></p>
            </div>
            <div class="bg-blue-500 text-white p-5 rounded-lg shadow">
                <h2 class="text-lg font-semibold">Total Visitors</h2>
                <p class="text-2xl font-bold"><?= number_format($total_visitors) ?></p>
            </div>
        </div>

        <!-- Graphs -->
        <div class="mt-8 grid grid-cols-2 gap-6">
            <!-- Most Popular Room Types -->
            <div class="bg-white p-5 rounded-lg shadow">
                <h2 class="text-xl font-semibold mb-3">Most Popular Room Types</h2>
                <canvas id="roomChart"></canvas>
            </div>

            <!-- Bookings Per Month -->
            <div class="bg-white p-5 rounded-lg shadow">
                <h2 class="text-xl font-semibold mb-3">Bookings Per Month</h2>
                <canvas id="monthChart"></canvas>
            </div>

            <!-- Bookings Per Day -->
            <div class="col-span-2 bg-white p-5 rounded-lg shadow">
                <h2 class="text-xl font-semibold mb-3">Bookings Per Day</h2>
                <canvas id="dayChart"></canvas>
            </div>
        </div>
    </div>

    <script>
        // Room Type Chart
        const roomCtx = document.getElementById('roomChart').getContext('2d');
        new Chart(roomCtx, {
            type: 'bar',
            data: {
                labels: <?= json_encode(array_keys($room_types)) ?>,
                datasets: [{
                    label: 'Bookings',
                    data: <?= json_encode(array_values($room_types)) ?>,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)'
                }]
            }
        });

        // Bookings Per Month
        const monthCtx = document.getElementById('monthChart').getContext('2d');
        new Chart(monthCtx, {
            type: 'line',
            data: {
                labels: <?= json_encode(array_keys($bookings_per_month)) ?>,
                datasets: [{
                    label: 'Bookings',
                    data: <?= json_encode(array_values($bookings_per_month)) ?>,
                    borderColor: 'rgba(255, 99, 132, 1)',
                    fill: false
                }]
            }
        });

        // Bookings Per Day
        const dayCtx = document.getElementById('dayChart').getContext('2d');
        new Chart(dayCtx, {
            type: 'line',
            data: {
                labels: <?= json_encode(array_keys($bookings_per_day)) ?>,
                datasets: [{
                    label: 'Bookings',
                    data: <?= json_encode(array_values($bookings_per_day)) ?>,
                    borderColor: 'rgba(75, 192, 192, 1)',
                    fill: false
                }]
            }
        });
    </script>
</body>
</html>
