<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include '../includes/db.php';

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $conn->real_escape_string($_POST['name']);
    $room_type = $conn->real_escape_string($_POST['room_type']);
    $description = $conn->real_escape_string($_POST['description']);
    $price = floatval($_POST['price']);

    // Handle image upload
    $image_path = "";
    if (!empty($_FILES['image']['name'])) {
        $target_dir = "../uploads/";
        $image_path = $target_dir . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], $image_path);
    }

    // Insert into database
    $sql = "INSERT INTO accommodations (name, description, room_type, price, image_path) 
            VALUES ('$name', '$description','$room_type', '$price', '$image_path')";
    
    if ($conn->query($sql)) {
        echo "<p class='text-green-600'>Accommodation added successfully!</p>";
    } else {
        echo "<p class='text-red-600'>Error: " . $conn->error . "</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Add Accommodation</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/js/all.min.js"></script>
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2">
                <a href="admin_dashboard.php" class="flex items-center py-2 px-3 bg-gray-700 rounded">
                    <i class="fas fa-chart-line mr-2"></i> Dashboard
                </a>
            </li>
            <li class="mb-2">
                <a href="admin.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-calendar-check mr-2"></i> Bookings
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_rooms.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-bed mr-2"></i> Rooms
                </a>
            </li>
            <li class="mb-2">
                <a href="manage_users.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-users mr-2"></i> Users
                </a>
            </li>
            <li class="mb-2">
                <a href="add_accommodation.php" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-plus-circle mr-2"></i> Add Accommodation
                </a>
            </li>
            <li class="mb-2">
                <a href="../index.html" class="flex items-center py-2 px-3 hover:bg-gray-700 rounded">
                    <i class="fas fa-globe mr-2"></i> View Website
                </a>
            </li>
        </ul>
    </div>

    <!-- Main Content -->
<div class="w-3/4 p-10">
    <h1 class="text-3xl font-bold mb-4">Add New Accommodation</h1>
    <form method="POST" enctype="multipart/form-data">
        <label class="block font-medium">Name:</label>
        <input type="text" name="name" class="w-full p-2 border rounded mb-3" required>

        <label class="block font-medium">Room Type:</label>
        <select name="room_type" class="w-full p-2 border rounded mb-3" required>
            <option value="Duplex">Duplex</option>
            <option value="Suite">Suite</option>
            <option value="Villa">Villa</option>
            <option value="Single">Single</option>
            <option value="Double">Double</option>
        </select>

        <label class="block font-medium">Description:</label>
        <textarea name="description" class="w-full p-2 border rounded mb-3" required></textarea>

        <label class="block font-medium">Price (Ksh):</label>
        <input type="number" name="price" class="w-full p-2 border rounded mb-3" required>

        <label class="block font-medium">Image:</label>
        <input type="file" name="image" class="w-full p-2 border rounded mb-3">

        <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">Add Accommodation</button>
    </form>
</div>

