<?php
session_start();
include '../includes/db.php';

// Fetch accommodations from the database
$query = "SELECT * FROM accommodations";
$result = $conn->query($query);

if (!$result) {
    die("Error fetching accommodations: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accommodations | Bungoma  Resort</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body class="bg-gray-100">

    <!-- 🔹 Promo Banner -->
    <div class="bg-yellow-400 text-black text-center py-3 text-sm font-semibold">
        LIMITED TIME OFFER - Get <span class="underline">two nights free</span> with your stay. 
        Click to explore our current promotions.
    </div>

    <!-- 🔹 Navigation Bar -->
    <nav class="flex items-center justify-between px-10 py-6">
        <div class="flex items-center space-x-4">
            <img src="assets/images/resortlogo.png" alt="Resort Logo" class="h-10">
        </div>
        <div class="space-x-8 hidden md:flex">
            <a href="accommodations.php" class="hover:text-yellow-400">ACCOMMODATIONS</a>
            <a href="activities.html" class="hover:text-yellow-400">ACTIVITIES</a>
            <a href="gallery.html" class="hover:text-yellow-400">GALLERY</a>
            <a href="contact.html" class="hover:text-yellow-400">Contact</a>
            <a href="login.php" class="hover:text-yellow-400">Login</a>
            <a href="register.php" class="hover:text-yellow-400">Register</a>
        </div>
        <div>
            <a href="book.php" class="border border-red px-4 py-2 text-black hover:bg-white hover:text-black transition">
                BOOK YOUR STAY
            </a>
        </div>
    </nav>

    <!-- 🔹 Hero Section -->
    <section class="text-center py-16 bg-cover bg-center" style="background-image: url('resort.jpg');">
        <h1 class="text-5xl font-bold text-black">Our Accommodations</h1>
        <p class="text-black-200 mt-4">Discover luxury rooms and suites with breathtaking views.</p>
    </section>

    <!-- 🔹 Search Bar -->
    <div class="flex justify-center my-6">
        <input type="text" id="search" class="w-1/2 p-3 border rounded-lg shadow-lg" placeholder="Search by name or room type...">
    </div>

    <!-- 🔹 Rooms & Suites Grid -->
    <section class="py-16 px-6 md:px-20">
        <div class="grid md:grid-cols-3 gap-8" id="accommodation-list">
            <?php while ($row = $result->fetch_assoc()) : ?>
                <div class="accommodation bg-white shadow-lg rounded-lg overflow-hidden p-4">
                    <img src="<?php echo htmlspecialchars($row['image_path']); ?>" alt="<?php echo htmlspecialchars($row['name']); ?>" class="w-full h-56 object-cover">
                    <div class="p-6">
                        <h2 class="text-2xl font-semibold"><?php echo htmlspecialchars($row['name']); ?></h2>
                        <p class="text-gray-600 mt-2"><?php echo htmlspecialchars($row['room_type']); ?></p>
                        <p class="text-gray-600 mt-2"><?php echo htmlspecialchars($row['description']); ?></p>
                        <p class="text-xl font-bold mt-4">Ksh <?php echo number_format($row['price']); ?> / night</p>
                        <a href="book.php?room_id=<?php echo $row['id']; ?>" class="block bg-blue-500 text-white text-center py-2 mt-4 rounded hover:bg-blue-700">Book Now</a>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    </section>

    <!-- 🔹 Footer -->
    <footer class="bg-black text-gray-300 text-center py-6">
        <p>© 2025 Bungoma Resort. All Rights Reserved.</p>
    </footer>

    <script>
        $(document).ready(function() {
            $("#search").on("keyup", function() {
                let searchText = $(this).val().toLowerCase();
                $(".accommodation").each(function() {
                    let roomName = $(this).find("h2").text().toLowerCase();
                    let roomType = $(this).find("p").eq(0).text().toLowerCase();

                    if (roomName.includes(searchText) || roomType.includes(searchText)) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
        });
    </script>

</body>
</html>

<?php
$conn->close();
?>
