<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include 'includes/db.php';

$sql = "SELECT * FROM booking ORDER BY id DESC";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Admin - Manage Bookings</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="flex">
    <!-- Sidebar -->
    <div class="w-1/4 bg-gray-800 text-white min-h-screen p-5">
        <h2 class="text-xl font-bold">Admin Panel</h2>
        <ul class="mt-4">
            <li class="mb-2"><a href="admin.php" class="block py-2 px-3 bg-gray-700 rounded">Bookings</a></li>
            <li class="mb-2"><a href="manage_rooms.php" class="block py-2 px-3 hover:bg-gray-700 rounded">Rooms</a></li>
            <li class="mb-2"><a href="manage_users.php" class="block py-2 px-3 hover:bg-gray-700 rounded">Users</a></li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="w-3/4 p-10">
        <h1 class="text-3xl font-bold">Booking Management</h1>
        <table class="mt-5 w-full border">
            <tr class="bg-gray-300">
                <th>ID</th>
                <th>Name</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Check-in</th>
                <th>Check-out</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
            <?php while ($row = $result->fetch_assoc()): ?>
            <tr class="border">
                <td><?= $row['id'] ?></td>
                <td><?= $row['name'] ?></td>
                <td><?= $row['phone'] ?></td>
                <td><?= $row['email'] ?></td>
                <td><?= $row['check_in'] ?></td>
                <td><?= $row['check_out'] ?></td>
                <td class="font-bold <?= $row['status'] == 'confirmed' ? 'text-green-600' : 'text-red-600' ?>">
                    <?= $row['status'] ?>
                </td>
                <td>
                    <a href="update_status.php?id=<?= $row['id'] ?>&status=confirmed" 
                       class="text-blue-600">Confirm</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </table>
    </div>
</body>
</html>
